/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.task.TargetFilteringApp;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.text.MessageFormat;

public class FilterBean
implements DataBean,
TaskActionListener,
TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMFBNT";
    private static final String TRACE_MASKF = "XFRMFBNF";
    private static final String TRACE_MASKD = "XFRMFBND";
    private static final String highlightText = "<html><body bgcolor=\"RED\"><font color=\"BLACK\">{0}</font></body></html>";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "FilterBean");
    private LocalizableText taskName = null;
    private CompletionReport[] targetInfo = null;
    private LocalizableText[] targetData = null;
    private UserTaskManager utm;
    private TargetFilteringApp app;
    private PresentationTaskParms parms = null;
    private ItemDescriptor[] m_idFilterTable;
    private ColumnDescriptor[] m_cdFilterTableStructure;
    private int[] m_iFilterTableSelection;

    public FilterBean(LocalizableText[] names, CompletionReport[] report, TargetFilteringApp app) {
        Trace.trace(TRACE_MASKT, "<> FilterBean:ctr()");
        this.targetInfo = report;
        this.targetData = names;
        this.app = app;
    }

    public ColumnDescriptor[] getFilterTableRowStructure() {
        return this.m_cdFilterTableStructure;
    }

    public int getFilterTableRowStatus() {
        return 3;
    }

    public int getFilterTableRowCount() {
        int retCount = this.m_idFilterTable.length / 2;
        return retCount;
    }

    public ItemDescriptor[] getFilterTableRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[2];
        int i = 0;
        while (i < 2) {
            rowAt[i] = this.m_idFilterTable[index * 2 + i];
            ++i;
        }
        return rowAt;
    }

    public void setFilterTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        int i = 0;
        while (i < 2) {
            this.m_idFilterTable[index * 2 + i] = items[i];
            ++i;
        }
    }

    public int[] getFilterTableSelection() {
        Trace.trace(TRACE_MASKT, "-> getFilterTableSelection()");
        return this.m_iFilterTableSelection;
    }

    public void setFilterTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iFilterTableSelection = new int[selected.length];
        int i = 0;
        while (i < selected.length) {
            this.m_iFilterTableSelection[i] = selected[i];
            ++i;
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load");
        Trace.trace(TRACE_MASKT, "length = " + this.targetData.length);
        int numRows = this.targetData.length;
        this.m_idFilterTable = new ItemDescriptor[numRows * 2];
        this.m_cdFilterTableStructure = new ColumnDescriptor[0];
        this.m_iFilterTableSelection = new int[0];
        int i = 0;
        while (i < numRows) {
            ItemDescriptor[] newRow = new ItemDescriptor[2];
            newRow[0] = new ItemDescriptor("Report" + i, this.targetData[i].toString());
            if (this.targetInfo[i].getText() != null) {
                if (this.targetInfo[i].getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                    newRow[1] = new ItemDescriptor("Names" + i, this.targetInfo[i].getText().toString());
                } else {
                    Object[] subst = new Object[]{this.targetInfo[i].getText().toString().replace('\n', ':')};
                    newRow[1] = new ItemDescriptor("Names" + i, MessageFormat.format(highlightText, subst));
                }
            } else {
                String noData = new LocalizableText(BaseTextBundle.getBundleName(), "target.filter.no.data").toString();
                Object[] subst = new Object[]{noData};
                newRow[1] = new ItemDescriptor("Names" + i, MessageFormat.format(highlightText, subst));
            }
            this.setFilterTableRowAt(i, newRow);
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- load");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "<> FilterBean:prepare()");
    }

    public void actionPerformed(TaskActionEvent evt) {
        block5: {
            Trace.trace(TRACE_MASKT, "-> FilterBean:panelAction()");
            try {
                String command = evt.getActionCommand();
                Trace.trace(TRACE_MASKT, "-> FilterBean for command: [" + command + "].");
                this.utm = (UserTaskManager)evt.getSource();
                this.utm.storeAllElements();
                this.utm.dispose();
                Trace.trace(TRACE_MASKF, "command = " + command);
                if (command.equals("CancelButton")) {
                    this.app.doButton(command, null);
                    break block5;
                }
                if (command.equals("NoButton")) {
                    this.app.doButton(command, null);
                    this.utm.dispose();
                    break block5;
                }
                if (command.equals("YesButton")) {
                    this.app.doButton(command, this.getFilterTableSelection());
                    this.utm.dispose();
                    break block5;
                }
                Trace.trace(TRACE_MASKF, "command = " + command + " not covered by PanelAction");
                this.app.doButton(command, null);
                this.utm.dispose();
            }
            catch (Exception ex) {
                Trace.trace(TRACE_MASKT, "FilterBean.panelAction exception: " + ex);
                new FrameworkLog(classLogInfo, 64, ex).log();
            }
        }
    }

    public void setUTM(UserTaskManager utm) {
        this.utm = utm;
    }
}

